<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Income extends Eloquent {

	protected $table = 'income';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('site_id', 'name', 'amount', 'note', 'check_number', 'check_date');

	public function site()
	{
		return $this->belongsTo('Sites', 'site_id');
	}

}