<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Stores extends Eloquent {

	protected $table = 'stores';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('site_id', 'employee_id');

	public function site()
	{
		return $this->belongsTo('Sites', 'site_id');
	}

	public function employee()
	{
		return $this->belongsTo('Employees', 'employee_id');
	}

}