<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Expenses extends Eloquent {

	protected $table = 'expenses';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('site_id', 'amount', 'date', 'note', 'type', 'expense_item');

	public function site()
	{
		return $this->belongsTo('Sites', 'site_id');
	}

}