<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSalaryTable extends Migration {

	public function up()
	{
		Schema::create('salary', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->date('month');
			$table->integer('employee_id');
			$table->double('total_hours');
			$table->double('deduction')->default('0');
			$table->double('loan')->default('0');
			$table->integer('site_id');
			$table->double('total');
			$table->double('salary');
			$table->integer('total_days');
		});
	}

	public function down()
	{
		Schema::drop('salary');
	}
}