<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFlatTable extends Migration {

	public function up()
	{
		Schema::create('flat', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name')->nullable();
			$table->string('address')->nullable();
			$table->double('amount')->nullable();
			$table->text('note')->nullable();
			$table->datetime('last_payment')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('flat');
	}
}