<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateItemsTable extends Migration {

	public function up()
	{
		Schema::create('items', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name')->nullable();
			$table->string('item_type')->nullable();
			$table->string('type')->nullable();
			$table->double('amount')->nullable();
			$table->integer('quantity')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('items');
	}
}