<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Employees extends Eloquent {

	protected $table = 'employees';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'position', 'daily_salary', 'national_id', 'mobile', 'job_number', 'house_allowance', 'site_id');

	public function site()
	{
		return $this->belongsTo('Sites', 'site_id');
	}

}