<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDimProductTable extends Migration {

	public function up()
	{
		Schema::create('Dim_Product', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('product_key');
			$table->integer('product_id');
			$table->string('product_code');
			$table->string('product_desc');
			$table->string('principal');
			$table->string('brand');
			$table->string('flavor');
			$table->string('packaging');
			$table->string('sub_packaging');
			$table->string('kelompok');
			$table->string('channel');
			$table->string('group_nasa');
			$table->string('item_group');
			$table->string('item_monitoring');
			$table->string('sub_brand');
			$table->string('active_status');
			$table->integer('weight_per_qty');
			$table->integer('serving_per_qty');
			$table->integer('kdi_conversional');
			$table->integer('box_conversional');
			$table->string('item_global_desc');
			$table->string('production_category');
			$table->string('production_sub_category');
			$table->string('category');
			$table->integer('lead_time_production');
			$table->integer('lead_time_quarantine');
			$table->float('unit_weight');
			$table->float('unit_volume');
			$table->string('source');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('Dim_Product');
	}
}