<?php

namespace App/Models;

use Illuminate\Database\Eloquent\Model;

class CourseOrder extends Model 
{

    protected $table = 'courses_orders';
    public $timestamps = true;
    protected $fillable = array('user_id', 'student_name', 'student_email', 'student_phone', 'country_id', 'ages_group_id', 'city_id', 'start_date', 'end_date', 'weeks_number', 'accommodation', 'course_id', 'transportation', 'accommodation_id', 'estimated_total_price', 'advisor_id', 'status', 'tracking_number', 'technetion_id');

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function country()
    {
        return $this->belongsTo('Country', 'country_id');
    }

    public function age_group()
    {
        return $this->belongsTo('AgeGroups', 'ages_goup_id');
    }

    public function city()
    {
        return $this->belongsTo('City', 'city_id');
    }

    public function accommodation()
    {
        return $this->belongsTo('Accommodation', 'accomodation_id');
    }

    public function course()
    {
        return $this->belongsTo('Course', 'course_id');
    }

}