<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMessagesTable extends Migration {

	public function up()
	{
		Schema::create('messages', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->bigInteger('to_id');
			$table->bigInteger('from_id');
			$table->bigInteger('channel_id');
			$table->longText('value')->nullable();
			$table->boolean('read')->default(0);
		});
	}

	public function down()
	{
		Schema::drop('messages');
	}
}