<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('cash_backs', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('cash_backs')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('cash_outs', function(Blueprint $table) {
			$table->foreign('payment_type_id')->references('id')->on('payment_types')
						->onDelete('set null')
						->onUpdate('set null');
		});
	}

	public function down()
	{
		Schema::table('cash_backs', function(Blueprint $table) {
			$table->dropForeign('cash_backs_order_id_foreign');
		});
		Schema::table('cash_outs', function(Blueprint $table) {
			$table->dropForeign('cash_outs_payment_type_id_foreign');
		});
	}
}