<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('feed_details', function(Blueprint $table) {
			$table->foreign('feed_id')->references('id')->on('feeds')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('feed_photos', function(Blueprint $table) {
			$table->foreign('feed_details_id')->references('id')->on('feed_details')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('feed_users', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('user')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('feed_users', function(Blueprint $table) {
			$table->foreign('feed_id')->references('id')->on('feeds')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('notification_details', function(Blueprint $table) {
			$table->foreign('notification_id')->references('id')->on('notification')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('notification_details', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('user')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('resources_users', function(Blueprint $table) {
			$table->foreign('resources_id')->references('id')->on('resources')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('resources_users', function(Blueprint $table) {
			$table->foreign('resources_details_id')->references('id')->on('resources_details')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('resources_details', function(Blueprint $table) {
			$table->foreign('resources_id')->references('id')->on('resources')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('event_feed_galleries', function(Blueprint $table) {
			$table->foreign('event_feed_id')->references('id')->on('event_feeds')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('event_session_infos', function(Blueprint $table) {
			$table->foreign('event_day_info_id')->references('id')->on('event_day_info')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('event_session_infos', function(Blueprint $table) {
			$table->foreign('event_track_id')->references('id')->on('event_track_infos')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('event_session_infos', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('user')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('event_speakers', function(Blueprint $table) {
			$table->foreign('event_session_info_id')->references('id')->on('event_session_infos')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('event_speakers', function(Blueprint $table) {
			$table->foreign('speaker_id')->references('id')->on('speaker')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('event_track_infos', function(Blueprint $table) {
			$table->foreign('event_day_info_id')->references('id')->on('event_day_info')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('speaker', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('user')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('judge_infos', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('user')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('thougthawards_details', function(Blueprint $table) {
			$table->foreign('thougthawards_id')->references('id')->on('thougthawards')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('feed_details', function(Blueprint $table) {
			$table->dropForeign('feed_details_feed_id_foreign');
		});
		Schema::table('feed_photos', function(Blueprint $table) {
			$table->dropForeign('feed_photos_feed_details_id_foreign');
		});
		Schema::table('feed_users', function(Blueprint $table) {
			$table->dropForeign('feed_users_user_id_foreign');
		});
		Schema::table('feed_users', function(Blueprint $table) {
			$table->dropForeign('feed_users_feed_id_foreign');
		});
		Schema::table('notification_details', function(Blueprint $table) {
			$table->dropForeign('notification_details_notification_id_foreign');
		});
		Schema::table('notification_details', function(Blueprint $table) {
			$table->dropForeign('notification_details_user_id_foreign');
		});
		Schema::table('resources_users', function(Blueprint $table) {
			$table->dropForeign('resources_users_resources_id_foreign');
		});
		Schema::table('resources_users', function(Blueprint $table) {
			$table->dropForeign('resources_users_resources_details_id_foreign');
		});
		Schema::table('resources_details', function(Blueprint $table) {
			$table->dropForeign('resources_details_resources_id_foreign');
		});
		Schema::table('event_feed_galleries', function(Blueprint $table) {
			$table->dropForeign('event_feed_galleries_event_feed_id_foreign');
		});
		Schema::table('event_session_infos', function(Blueprint $table) {
			$table->dropForeign('event_session_infos_event_day_info_id_foreign');
		});
		Schema::table('event_session_infos', function(Blueprint $table) {
			$table->dropForeign('event_session_infos_event_track_id_foreign');
		});
		Schema::table('event_session_infos', function(Blueprint $table) {
			$table->dropForeign('event_session_infos_user_id_foreign');
		});
		Schema::table('event_speakers', function(Blueprint $table) {
			$table->dropForeign('event_speakers_event_session_info_id_foreign');
		});
		Schema::table('event_speakers', function(Blueprint $table) {
			$table->dropForeign('event_speakers_speaker_id_foreign');
		});
		Schema::table('event_track_infos', function(Blueprint $table) {
			$table->dropForeign('event_track_infos_event_day_info_id_foreign');
		});
		Schema::table('speaker', function(Blueprint $table) {
			$table->dropForeign('speaker_user_id_foreign');
		});
		Schema::table('judge_infos', function(Blueprint $table) {
			$table->dropForeign('judge_infos_user_id_foreign');
		});
		Schema::table('thougthawards_details', function(Blueprint $table) {
			$table->dropForeign('thougthawards_details_thougthawards_id_foreign');
		});
	}
}