<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name');
			$table->date('date');
			$table->string('shipping_address');
			$table->string('sub_total');
			$table->bigInteger('fees');
			$table->bigInteger('total');
			$table->date('delivery_date');
			$table->string('status');
			$table->bigInteger('shipping_id')->unsigned();
			$table->bigInteger('page_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}