<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBrandsTable extends Migration {

	public function up()
	{
		Schema::create('brands', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->bigInteger('category_id')->unsigned();
			$table->string('name', 50);
			$table->integer('release');
			$table->tinyInteger('status')->default('0');
		});
	}

	public function down()
	{
		Schema::drop('brands');
	}
}