<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Layer extends Model 
{

    protected $table = 'layers';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'data', 'layer_type_id', 'parent_layer_id', 'price');
    protected $visible = array('name', 'data', 'layer_type_id', 'parent_layer_id', 'price');

    public function layerType()
    {
        return $this->belongsTo('App\LayerType');
    }

}