<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLayersTable extends Migration {

	public function up()
	{
		Schema::create('layers', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name');
			$table->text('data');
			$table->integer('layer_type_id')->unsigned()->index();
			$table->integer('parent_layer_id')->unsigned();
			$table->integer('price')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('layers');
	}
}