<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateContactRequestsTable extends Migration {

	public function up()
	{
		Schema::create('contact_requests', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('full_name');
			$table->string('phone_number');
			$table->string('email');
			$table->string('content');
			$table->enum('status', array(''new'', ''read'', ''handling''));
		});
	}

	public function down()
	{
		Schema::drop('contact_requests');
	}
}