<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateQuestionsTable extends Migration {

	public function up()
	{
		Schema::create('questions', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('layer_id');
			$table->text('content')->nullable();
			$table->string('picture');
			$table->text('raw_answer')->nullable();
			$table->text('complete_answer')->nullable();
			$table->text('video_answer')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('questions');
	}
}