<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('user_id')->unsigned();
			$table->integer('payment_type_id')->unsigned();
			$table->text('payment_data');
			$table->enum('status', array(''pending'', ''completed'', ''canceled'', ''declined''));
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}