<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOauthClientsTable extends Migration {

	public function up()
	{
		Schema::create('oauth_clients', function(Blueprint $table) {
			$table->integer('id', true);
			$table->bigInteger('user_id');
			$table->string('name', 255);
			$table->string('secret', 100);
			$table->text('redirect');
			$table->tinyInteger('personal_access_client');
			$table->tinyInteger('password_client');
			$table->tinyInteger('revoked');
			$table->timestamp('created_at');
			$table->timestamp('updated_at');
		});
	}

	public function down()
	{
		Schema::drop('oauth_clients');
	}
}