<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTenantsTable extends Migration {

	public function up()
	{
		Schema::create('tenants', function(Blueprint $table) {
			$table->increments('id');
			$table->uuid('tenant_id')->unique()->primary();
			$table->string('name');
			$table->string('domain');
			$table->string('created_at');
			$table->string('updated_at');
			$table->integer('timestamp');
		});
	}

	public function down()
	{
		Schema::drop('tenants');
	}
}