<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 150);
			$table->string('email', 150);
			$table->string('phone', 100);
			$table->string('country_code', 10);
			$table->integer('city_id')->unsigned()->nullable();
			$table->string('password', 150);
			$table->string('bank_name', 150);
			$table->string('account_number', 150);
			$table->string('bank_owner_name', 150);
			$table->string('iban', 150);
			$table->integer('activity_id')->unsigned()->nullable();
			$table->string('activity_description', 150);
			$table->string('code', 50);
			$table->string('lang', ar);
			$table->double('wallet', 8,2);
			$table->string('image', 150)->default('default.png');
			$table->boolean('is_active')->default(0);
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}