<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductRatesTable extends Migration {

	public function up()
	{
		Schema::create('product_rates', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('merchant_id')->unsigned()->nullable();
			$table->integer('product_id')->unsigned()->nullable();
			$table->integer('rate')->nullable();
			$table->text('comment')->nullable();
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('product_rates');
	}
}