<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateQuestionCategoriesTable extends Migration {

	public function up()
	{
		Schema::create('question_categories', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title', 100);
			$table->text('description')->nullable();
			$table->string('image', 100)->nullable();
			$table->enum('status', array('pending', 'accepted', 'refused'))->nullable();
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('question_categories');
	}
}