<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAboutsTable extends Migration {

	public function up()
	{
		Schema::create('abouts', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title', 100);
			$table->text('description')->nullable();
			$table->string('image', 100)->nullable();
			$table->string('logo', 100)->nullable();
			$table->string('video', 100)->nullable();
			$table->string('phone_number', 20)->nullable();
			$table->string('email', 50)->nullable();
			$table->string('address', 150)->nullable();
			$table->enum('status', array('pending', 'progress', 'done'))->nullable();
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('abouts');
	}
}