<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateContactsTable extends Migration {

	public function up()
	{
		Schema::create('contacts', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title', 100)->nullable();
			$table->text('description')->nullable();
			$table->string('email', 50)->nullable();
			$table->string('phone_number', 20)->nullable();
			$table->enum('status', array('pending', 'progress', 'done'))->nullable();
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('contacts');
	}
}