<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('merchant_rates', function(Blueprint $table) {
			$table->foreign('merchant_id')->references('id')->on('blogs')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('product_rates', function(Blueprint $table) {
			$table->foreign('merchant_id')->references('id')->on('blogs')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('product_rates', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('blogs')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('questions', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('question_categories')
						->onDelete('set null')
						->onUpdate('set null');
		});
	}

	public function down()
	{
		Schema::table('merchant_rates', function(Blueprint $table) {
			$table->dropForeign('merchant_rates_merchant_id_foreign');
		});
		Schema::table('product_rates', function(Blueprint $table) {
			$table->dropForeign('product_rates_merchant_id_foreign');
		});
		Schema::table('product_rates', function(Blueprint $table) {
			$table->dropForeign('product_rates_product_id_foreign');
		});
		Schema::table('questions', function(Blueprint $table) {
			$table->dropForeign('questions_category_id_foreign');
		});
	}
}