<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateQuestionsTable extends Migration {

	public function up()
	{
		Schema::create('questions', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('category_id')->unsigned()->nullable();
			$table->string('question', 150);
			$table->text('answer');
			$table->enum('status', array('pending', 'accepted', 'refused'))->nullable();
		});
	}

	public function down()
	{
		Schema::drop('questions');
	}
}