<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateWalletDebitsTable extends Migration {

	public function up()
	{
		Schema::create('wallet_debits', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('wallet_id');
			$table->integer('customer_id');
			$table->double('wallet_debit_amount', 20,2);
			$table->string('wallet_debit_type', 100);
			$table->string('wallet_debit_status');
			$table->string('wallet_debit_description', 200);
			$table->integer('wallet_debit_for');
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('wallet_debits');
	}
}