<?php

namespace Module/Admin/Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Product extends Model 
{

    protected $table = 'products';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function slot_product_relation()
    {
        return $this->hasOne('Slot', 'product_id');
    }

    public function product_category_relation()
    {
        return $this->hasOne('Category', 'category_id');
    }

}