<?php

namespace Module/Admin/Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class RolePermission extends Model 
{

    protected $table = 'role_permissions';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function get_roles()
    {
        return $this->belongsToMany('Role', 'role_id');
    }

    public function get_permissions()
    {
        return $this->belongsToMany('Permission', 'permission_id');
    }

}