<?php

namespace Module/Admin/Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Wallet extends Model 
{

    protected $table = 'wallets';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function wallet_credit_relation()
    {
        return $this->hasMany('WalletCredits', 'wallet_id');
    }

    public function wallet_debit_relation()
    {
        return $this->hasOne('WalletDebits', 'wallet_id');
    }

}