<?php

namespace Module/Admin/Entities;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Address extends Eloquent {

	protected $table = 'addresses';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function order_address_relation()
	{
		return $this->hasOne('Order', 'address_id');
	}

	public function participation_address_relation()
	{
		return $this->hasOne('Participation', 'address_id');
	}

}