<?php

namespace Module/Admin/Entities;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Product extends Eloquent {

	protected $table = 'products';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function slot_product_relation()
	{
		return $this->hasOne('Slot', 'product_id');
	}

	public function product_category_relation()
	{
		return $this->hasOne('Category', 'category_id');
	}

}