<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('user_id');
			$table->integer('status');
			$table->integer('address_id');
			$table->integer('product_id');
			$table->integer('quantity');
			$table->double('grand_total', 20,2);
			$table->double('unit_price', 20,2);
			$table->string('payment_id', 100)->nullable();
			$table->float('delivery_charge', 8,2)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}