<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateQuizWinnersTable extends Migration {

	public function up()
	{
		Schema::create('quiz_winners', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('quiz_id');
			$table->integer('played_user_id');
			$table->enum('status', array('won', 'failed'));
		});
	}

	public function down()
	{
		Schema::drop('quiz_winners');
	}
}