<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSlotsTable extends Migration {

	public function up()
	{
		Schema::create('slots', function(Blueprint $table) {
			$table->string('draw_id', 100);
			$table->increments('id');
			$table->integer('product_id');
			$table->string('slot_code', 10);
			$table->integer('slot_count');
			$table->double('slot_price', 10,2);
			$table->string('slot_start', 100);
			$table->integer('slot_sold_out');
			$table->string('last_sold_out_slot', 100);
			$table->integer('status');
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('slots');
	}
}