<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class CarModel extends Model 
{

    protected $table = 'car_model';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('brand_id', 'name_en', 'name_ar');

    public function brand()
    {
        return $this->belongsTo('Brand', 'brand_id');
    }

}