<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class StoreModel extends Model 
{

    protected $table = 'store_model';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('store_id', 'model_id');

    public function store()
    {
        return $this->belongsTo('Store', 'store_id');
    }

    public function model()
    {
        return $this->belongsTo('CarModel', 'model_id');
    }

}