<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class StoreOrder extends Model 
{

    protected $table = 'store_order';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('store_id', 'order_id', 'status');

    public function store()
    {
        return $this->belongsTo('Store', 'store_id');
    }

    public function order()
    {
        return $this->belongsTo('Order', 'order_id');
    }

}