<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class StoreSpecialty extends Model 
{

    protected $table = 'store_specialty';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('store_id', 'specialty_id');

    public function store()
    {
        return $this->belongsTo('Store', 'store_id');
    }

    public function specialty()
    {
        return $this->belongsTo('Specialty', 'specialty_id');
    }

}