<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class OrderItem extends Eloquent {

	protected $table = 'order_item';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('order_id', 'name', 'number');

	public function order()
	{
		return $this->belongsTo('Order', 'order_id');
	}

	public function replies()
	{
		return $this->hasMany('OrderReply', 'item_id');
	}

}