<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class CarModel extends Eloquent {

	protected $table = 'car_model';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('brand_id', 'name_en', 'name_ar');

	public function brand()
	{
		return $this->belongsTo('Brand', 'brand_id');
	}

}