<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Client extends Eloquent {

	protected $table = 'client';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('phone', 'name', 'user_id');

	public function user()
	{
		return $this->belongsTo('User', 'user_id');
	}

}