<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class StoreModel extends Eloquent {

	protected $table = 'store_model';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('store_id', 'model_id');

	public function store()
	{
		return $this->belongsTo('Store', 'store_id');
	}

	public function model()
	{
		return $this->belongsTo('CarModel', 'model_id');
	}

}