<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Brand extends Eloquent {

	protected $table = 'brand';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name_en', 'name_ar', 'hide');

	public function models()
	{
		return $this->hasMany('CarModel', 'brand_id');
	}

}