<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class OrderCity extends Model 
{

    protected $table = 'order_city';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('order_id', 'city_id');

    public function order()
    {
        return $this->belongsTo('Order', 'order_id');
    }

    public function city()
    {
        return $this->belongsTo('City', 'city_id');
    }

}