<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Order extends Model 
{

    protected $table = 'order';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('brand_id', 'model_id', 'year', 'status', 'Chassis_number', 'client_id');

    public function brand()
    {
        return $this->belongsTo('Brand', 'brand_id');
    }

    public function model()
    {
        return $this->belongsTo('CarModel', 'model_id');
    }

    public function specialties()
    {
        return $this->belongsToMany('Specialty', 'order_specialty', 'order_id', 'specialty_id');
    }

    public function items()
    {
        return $this->hasMany('OrderItem', 'order_id');
    }

    public function cities()
    {
        return $this->belongsToMany('City', 'order_city', 'order_id', 'city_id');
    }

    public function replies()
    {
        return $this->hasMany('OrderReply', 'order_id');
    }

    public function client()
    {
        return $this->belongsTo('Client', 'client_id');
    }

}