<?php

namespace App/Models/;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Doctor extends Eloquent {

	protected $table = 'doctors';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('lang', 'name', 'phone', 'email', 'password', 'trem', 'status', 'latitude', 'longitude', 'location', 'fb_id', 'google_id', 'apple_id', 'pin_code', 'about', 'full_perfessional_title', 'd_o_b', 'softDeletes', 'year_experience', 'viewers');

	public function rattings()
	{
		return $this->hasMany('Patient');
	}

	public function bookings()
	{
		return $this->hasMany('Patient');
	}

	public function payment()
	{
		return $this->belongsTo('Payment');
	}

	public function offers()
	{
		return $this->morphToMany('Offer', 'offerable');
	}

	public function specialties()
	{
		return $this->hasMany('Specialty');
	}

	public function lisences()
	{
		return $this->hasMany('Lisence');
	}

	public function places()
	{
		return $this->hasMany('Place');
	}

	public function insuranceCompanies()
	{
		return $this->hasMany('InsuranceCompany');
	}

	public function doctorGeneralTitles()
	{
		return $this->hasMany('DoctorGeneralTitle');
	}

	public function assistants()
	{
		return $this->hasMany('Assistant');
	}

	public function bankAccounts()
	{
		return $this->hasMany('BankDoctor');
	}

	public function banks()
	{
		return $this->hasMany('Bank');
	}

	public function certificates()
	{
		return $this->hasMany('Certificate');
	}

}