<?php

namespace App/Models/;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class MedicalAnalysis extends Eloquent {

	protected $table = 'medical_analysis';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'analysis_for', 'note', 'medical_analysis_type_id', 'booking_id');

	public function medicalAnalysisType()
	{
		return $this->belongsTo('MedicalAnalysisType');
	}

	public function booking()
	{
		return $this->belongsTo('Booking');
	}

}